% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges.R
\name{ranges}
\alias{ranges}
\title{Derive variable ranges from linear restrictions}
\usage{
ranges(A, b, neq = nrow(A), nleq = 0, eps = 1e-08)
}
\arguments{
\item{A}{\code{[numeric]} Matrix}

\item{b}{\code{[numeric]} vector}

\item{neq}{[\code{numeric}] The first \code{neq} rows in \code{A} and
\code{b} are treated as linear equalities.}

\item{nleq}{[\code{numeric}] The \code{nleq} rows after \code{neq} are treated as
inequations of the form \code{a.x<=b}. All remaining rows are treated as strict inequations
of the form \code{a.x<b}.}

\item{eps}{\code{[numeric]} Coefficients with absolute value  \code{<= eps} are treated as zero.
using Fourier-Motzkin elimination.}
}
\description{
Gaussian and/or Fourier-Motzkin elimination is used 
to derive upper and lower limits implied by a system of (in)equations.
}

