% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.R
\name{block_index}
\alias{block_index}
\title{Find independent blocks of equations.}
\usage{
block_index(A, eps = 1e-08)
}
\arguments{
\item{A}{\code{[numeric]} Matrix}

\item{eps}{\code{[numeric]} Coefficients with absolute value \code{< eps} are treated as zero.}
}
\value{
A \code{list} containing \code{numeric} vectors, each vector indexing an independent
block of rows in the system \code{Ax <= b}.
}
\description{
Find independent blocks of equations.
}
\examples{

 A <- matrix(c(
   1,0,2,0,0,
   3,0,4,0,0,
   0,5,0,6,7,
   0,8,0,0,9
 ),byrow=TRUE,nrow=4)
 b <- rep(0,4)
 bi <- block_index(A)
 lapply(bi,function(ii) compact(A[ii,,drop=FALSE],b=b[ii])$A)


}
