% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_left_parentheses_linter.R
\name{function_left_parentheses_linter}
\alias{function_left_parentheses_linter}
\title{Function left parentheses linter}
\usage{
function_left_parentheses_linter()
}
\description{
Check that all left parentheses in a function call do not have spaces before them
(e.g. \code{mean  (1:3)}). Although this is syntactically valid, it makes the code
difficult to read.
}
\details{
Exceptions are made for control flow functions (\code{if}, \code{for}, etc.).
}
\examples{
# will produce lints
lint(
  text = "mean (x)",
  linters = function_left_parentheses_linter()
)

lint(
  text = "stats::sd(c (x, y, z))",
  linters = function_left_parentheses_linter()
)

# okay
lint(
  text = "mean(x)",
  linters = function_left_parentheses_linter()
)

lint(
  text = "stats::sd(c(x, y, z))",
  linters = function_left_parentheses_linter()
)

lint(
  text = "foo <- function(x) (x + 1)",
  linters = function_left_parentheses_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#parentheses}
\item \code{\link[=spaces_left_parentheses_linter]{spaces_left_parentheses_linter()}}
}
}
\section{Tags}{
\link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
