% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarios.R
\name{qtSVM}
\alias{qtSVM}
\alias{svmQuantileRegression}
\title{Quantile Regression}
\usage{
qtSVM(x, y, ..., weights = c(0.05, 0.1, 0.5, 0.9, 0.95), clipping = -1,
  do.select = TRUE)

svmQuantileRegression(x, y, ..., weights = c(0.05, 0.1, 0.5, 0.9, 0.95),
  clipping = -1, do.select = TRUE)
}
\arguments{
\item{x}{either a formula or the features}

\item{y}{either the data or the labels corresponding to the features \code{x}.
It can be a \code{character} in which case the data is loaded using \code{\link{liquidData}}.
If it is of type \code{liquidData} then after \code{train}ing and \code{select}ion
the model is \code{\link{test}}ed using the testing data (\code{y$test}).}

\item{...}{configuration parameters, see \link{Configuration}. Can be \code{threads=2, display=1, gpus=1,} etc.}

\item{weights}{the quantiles that should be estimated}

\item{clipping}{absolute value where the estimated labels will be clipped. -1 (the default)
leads to an adaptive clipping value, whereas 0 disables clipping.}

\item{do.select}{if \code{TRUE} also does the whole selection for this model}
}
\value{
an object of type \code{svm}. Depending on the usage this object
has also \code{$train_errors}, \code{$select_errors}, and \code{$last_result}
properties.
}
\description{
This routine performs non-parametric and quantile regression using SVMs. 
The tested estimators are therefore estimating the conditional tau-quantiles 
of Y given X. By default, estimators for five different tau values 
are computed.
\code{svmQuantileRegression} is a simple alias of \code{qtSVM}.
}
\examples{
\dontrun{
tt <- ttsplit(quakes)
model <- qtSVM(mag~., tt$train, display=1)
result <- test(model, tt$test)

errors(result)[2] ## is the same as
mean(ifelse(result[,2]<tt$test$mag, -.1,.9) * (result[,2]-tt$test$mag))
}
}

