% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liquidSVM.R
\name{errors}
\alias{errors}
\title{Obtain the test errors result.}
\usage{
errors(y, showall = FALSE)
}
\arguments{
\item{y}{the results of \code{\link{test.liquidSVM}}}

\item{showall}{show the more detailed errors as well.}
}
\value{
for all tasks the global and optionally also the positive/negative errors.
Depending on the learning scenario there can be also a overall error (e.g. in multi-class classification).
}
\description{
After calculating the result in \code{\link{test.liquidSVM}} if labels
were given \pkg{liquidSVM} also calculates the test error.
}
\details{
Depending on the learning scenario there can be multiple errors: usually there is one  per task,
and \code{\link{mcSVM}} adds in front the global classification error.
In the latter case the names give an information for what task the error was computed.

For each error also the positive and negative validation error can be shonw using \code{showall}
for example in \code{\link{rocSVM}}.
}
\examples{
modelTrees <- svm(Height ~ Girth + Volume, trees[1:10, ])  # least squares

y <- test(modelTrees,trees[-1:-10,])
errors(y)

\dontrun{
banana <- liquidData('banana-bc')
s_banana <- rocSVM(Y~., banana$test)
result <- test(s_banana, banana$train)
errors(result, showall=TRUE)
}
}
\seealso{
\code{\link{test.liquidSVM}}
}
