% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listWithDefaults.R
\name{listWithDefaults}
\alias{listWithDefaults}
\title{listWithDefaults}
\usage{
listWithDefaults(..., defaultList = NULL)
}
\arguments{
\item{...}{objects, \emph{must} be named}

\item{defaultList}{a \emph{named} list containing the default values}
}
\description{
Takes arguments as \code{base::list} to create a list.
If any arguments are present in \code{defaultList}, but absent in ..., then the values from \code{defaultList} are used.
}
\note{
Argument order is not controlled.  Non-default arguments come first in the order specified followed by all default arguments.
}
\examples{
listWithDefaults(defaultList=list(a=2,b=2))
listWithDefaults(a=1,defaultList=list(a=2,b=2))
listWithDefaults(b=1,defaultList=list(a=2,b=2))
listWithDefaults(a=1,b=1,defaultList=list(a=2,b=2))
}

