% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{wilcoxon}
\alias{wilcoxon}
\alias{test_statistic.wilcoxon}
\alias{p_value.wilcoxon}
\title{Wilcoxon Test}
\usage{
wilcoxon(x, type = c("both", "greater", "less"), mu = 0)

\method{test_statistic}{wilcoxon}(x, ...)

\method{p_value}{wilcoxon}(x, ...)
}
\arguments{
\item{x}{numeric vector representing a time-series.}

\item{type}{direction to test (both, increasing, or decreasing).}

\item{mu}{baseline value (null hypothesis)}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
object of class \code{wilcoxon}.
}
\description{
Constructor for a Wilcoxon test (simple wrapper for \code{\link{wilcox.test}}).
}
\section{Methods (by generic)}{
\itemize{
\item \code{test_statistic(wilcoxon)}: Extract test statistic V

\item \code{p_value(wilcoxon)}: Extract p-value

}}
\examples{

# create wilcoxon object
w <- wilcoxon(c(9, 4, 7, 5, 3), type = "less")

# get test statistic V
test_statistic(w)

# get p-value
p_value(w)
}
\seealso{
\code{\link{wilcox.test}}, \code{\link{p_value}},
  \code{\link{test_statistic}}
}
