### $Id: IGF.q,v 1.3 1998/04/10 22:52:03 bates Exp $
### Radioimmunoassay data for the protein Insulin-like Growth Factor
### Davidian and Giltinan (1995), section 3.2.1, p. 65.
"IGF" <-
  structure(list(
   Lot = structure(ordered(c(3, 3, 3, 3, 3, 3, 3, 
     3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
     5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
     5, 5, 5, 5, 5, 5, 5, 5, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
     9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 
     9, 9, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 
     8, 8, 8, 8, 8, 8, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 
     7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 2, 2, 2, 2, 10, 
     10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
     10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 
     10, 10, 10, 10, 10, 10, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
     1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4), levels=1:10),
     class = c("ordered", "factor"),
     .Label = c("9", "6", "1", "10", "2", "8", "5", "4", "3", "7")),
   age = c(7, 7, 8, 8, 13, 13, 14, 14, 15, 15, 22, 23, 
     24, 27, 28, 28, 30, 34, 34, 35, 35, 36, 36, 36, 41, 42, 42, 43, 
     3, 3, 3, 6, 11, 11, 11, 12, 12, 13, 13, 13, 18, 24, 24, 25, 25, 
     26, 27, 27, 32, 32, 34, 38, 40, 42, 45, 46, 47, 1, 2, 5, 6, 7, 
     8, 13, 15, 15, 21, 21, 21, 22, 22, 27, 28, 28, 28, 29, 30, 30, 
     33, 34, 34, 35, 36, 37, 41, 42, 43, 44, 47, 47, 48, 49, 50, 5, 
     5, 5, 5, 7, 9, 11, 11, 12, 12, 14, 14, 14, 14, 14, 15, 19, 19, 
     20, 20, 22, 22, 25, 25, 26, 1, 2, 6, 6, 7, 9, 10, 15, 15, 15, 
     15, 17, 21, 22, 23, 24, 24, 24, 29, 30, 35, 37, 37, 37, 37, 42, 
     43, 44, 44, 45, 48, 2, 3, 3, 4, 1, 2, 3, 4, 5, 7, 10, 10, 11, 
     15, 16, 17, 17, 18, 21, 22, 23, 24, 24, 26, 27, 29, 31, 31, 32, 
     36, 37, 38, 38, 39, 42, 43, 43, 45, 45, 45, 45, 47, 50, 1, 1, 
     2, 3, 6, 9, 9, 9, 4, 4, 5, 7, 8, 11, 13, 13, 13, 14, 15, 19, 
     20, 21, 25, 26, 26, 27, 27, 29, 29, 29, 30, 33, 34, 35, 35, 35, 
     36, 40, 41, 4, 5, 6, 6, 11, 13),
   conc = c(4.9, 5.68, 5.32, 5.5, 
     4.94, 5.19, 5.18, 5.67, 5.02, 5.88, 5.12, 5.24, 5.88, 5.4, 5.59, 
     5.77, 5.57, 5.86, 5.87, 4.65, 5.34, 4.93, 5.33, 4.99, 3.38, 5.44, 
     5.24, 5.39, 5.34, 5.27, 5.48, 5.15, 4.23, 5.77, 5.06, 5.33, 5.78, 
     5.01, 4.85, 4.94, 5.14, 5.43, 5.66, 5.62, 5.53, 6.2, 5.3, 4.09, 
     5.78, 5.66, 5.07, 5.45, 4.76, 4.81, 4.92, 4.32, 3.3, 5.88, 5.91, 
     0.86, 5.4, 4.94, 5.42, 5.4, 5.68, 5.71, 9.55, 5.94, 6.17, 5.34, 
     8.14, 5.51, 5.31, 4.81, 5.26, 4.72, 5.08, 3.99, 4.87, 4.92, 6.13, 
     6.3, 5.97, 5.98, 6.68, 5.33, 6.08, 4.76, 5.31, 6.66, 5.52, 5.48, 
     5.1, 5.12, 5.08, 4.63, 5.38, 5.78, 9.34, 5.58, 5.19, 5.25, 5.44, 
     5.31, 4.71, 5.67, 4.65, 5.05, 4.23, 5.02, 4.98, 5.08, 4.84, 4.84, 
     5.53, 5.85, 5.32, 5.47, 5.49, 5.43, 5.02, 5.29, 6.25, 4.63, 5.18, 
     5.17, 4.98, 5.38, 3.76, 5.63, 6.12, 4, 6.53, 4.67, 5.55, 5.62, 
     4.58, 5.41, 4.84, 4.83, 5.36, 4.81, 5.35, 5.46, 5.09, 4.78, 4.44, 
     4.67, 4.98, 4.56, 5.83, 5.27, 4.9, 4.94, 4.78, 5.42, 5.42, 5.38, 
     5.55, 5.81, 5.62, 6.08, 4.8, 5.32, 4.95, 5.44, 5.48, 5.26, 5.21, 
     4.65, 4.62, 5.15, 4.71, 5.02, 5.38, 5.34, 5.1, 5.69, 5, 5.02, 
     9.74, 9.6, 5.58, 4.94, 4.66, 5.23, 5.62, 5.53, 5.45, 4.63, 5.01, 
     5.43, 6.17, 5.57, 4.82, 5.84, 5.55, 5.17, 6.5, 5.36, 5.47, 5.57, 
     5.36, 4.93, 5.49, 3.25, 5.53, 4.91, 5.74, 4.95, 5.07, 5.54, 5.29, 
     4.59, 5.66, 4.69, 5.18, 5.19, 5.35, 5.28, 5.5, 5, 5.47, 5.55, 
     5.75, 5.41, 5.65, 5.25, 5.81, 4.71, 4.95, 6, 5.74, 5.68, 5.83, 
     5.3, 5.63)),
row.names = 1:237,
class = c("nfnGroupedData", "nfGroupedData", "groupedData", "data.frame"),
formula = conc ~ age | Lot,
labels = list(x = "Tracer age", y = "IGF-I concentration"),
units = list(x = "(days)", y = "(ng/ml)"))
