% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbasis.R
\name{bbasis}
\alias{bbasis}
\title{Function for creating B-spline basis functions (Eilers & Marx, 2010)}
\usage{
bbasis(x, xl, xr, ndx, deg)
}
\arguments{
\item{x}{A vector. Data values for spline.}

\item{xl}{A numeric value. Lower bound for data (lower external knot).}

\item{xr}{A numeric value. Upper bound for data (upper external knot).}

\item{ndx}{A numeric value. Number of divisions for x range
(equal to number of segments = number of internal knots + 1)}

\item{deg}{A numeric value. Degree of the polynomial spline.}
}
\value{
A matrix with columns holding the P-spline for each value of x.
    Matrix has \code{ndx+deg} columns and \code{length(x)} rows.
}
\description{
Construct a B-spline basis of degree \code{deg}
with \code{ndx-}1 equally-spaced internal knots (\code{ndx} segments) on range [\code{x1},\code{xr}].
Code copied from Eilers & Marx 2010, WIR: Comp Stat 2, 637-653.
}
\details{
Not yet amended to coerce values that should be zero to zero!
}
