% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contest.R
\name{contest1D.lmerModLmerTest}
\alias{contest1D.lmerModLmerTest}
\alias{contest1D.lmerMod}
\title{Contrast Tests in 1D}
\usage{
\method{contest1D}{lmerModLmerTest}(
  model,
  L,
  rhs = 0,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  confint = FALSE,
  level = 0.95,
  ...
)

\method{contest1D}{lmerMod}(
  model,
  L,
  rhs = 0,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  confint = FALSE,
  level = 0.95,
  ...
)
}
\arguments{
\item{model}{a model object fitted with \code{lmer} from package
\pkg{lmerTest}, i.e., an object of class \code{\link{lmerModLmerTest}}.}

\item{L}{a numeric (contrast) vector of the same length as
\code{fixef(model)}.}

\item{rhs}{right-hand-side of the statistical test, i.e. the hypothesized
value (a numeric scalar).}

\item{ddf}{the method for computing the denominator degrees of freedom.
\code{ddf="Kenward-Roger"} uses Kenward-Roger's method.}

\item{confint}{include columns for lower and upper confidence limits?}

\item{level}{confidence level.}

\item{...}{currently not used.}
}
\value{
A \code{data.frame} with one row and columns with \code{"Estimate"},
\code{"Std. Error"}, \code{"t value"}, \code{"df"}, and \code{"Pr(>|t|)"}
(p-value). If \code{confint = TRUE} \code{"lower"} and \code{"upper"} columns
are included before the p-value column.
}
\description{
Compute the test of a one-dimensional (vector) contrast in a
linear mixed model fitted with lmer from package \pkg{lmerTest}.
The contrast should specify a linear function of the
mean-value parameters, beta. The Satterthwaite or Kenward-Roger method is
used to compute the (denominator) df for the t-test.
}
\details{
The t-value and associated p-value is for the hypothesis
\eqn{L' \beta = \mathrm{rhs}}{L' \beta = rhs} in which rhs may be non-zero
and \eqn{\beta} is \code{fixef(model)}.
The estimated value (\code{"Estimate"}) is \eqn{L' \beta} with associated
standard error and (optionally) confidence interval.
}
\examples{

# Fit model using lmer with data from the lme4-package:
data("sleepstudy", package="lme4")
fm <- lmer(Reaction ~ Days + (1 + Days|Subject), sleepstudy)

# Tests and CI of model coefficients are obtained with:
contest1D(fm, c(1, 0), confint=TRUE) # Test for Intercept
contest1D(fm, c(0, 1), confint=TRUE) # Test for Days

# Tests of coefficients are also part of:
summary(fm)

# Illustrate use of rhs argument:
contest1D(fm, c(0, 1), confint=TRUE, rhs=10) # Test for Days-coef == 10


}
\seealso{
\code{\link[=contest.lmerModLmerTest]{contest}} for a flexible
and general interface to tests of contrasts among fixed-effect parameters.
\code{\link[=contestMD.lmerModLmerTest]{contestMD}} is also available as a
direct interface for tests of multi degree-of-freedom contrast.
}
\author{
Rune Haubo B. Christensen
}
