#' Junior school project math score data.
#' 
#' A dataset containing 728 students from 50 primary (elementary) schools in inner 
#' London that were part of the Junior School Project (JSP). The variables are
#' as follows:
#' 
#' @format A data frame with 728 rows and 8 variables.
#' \describe{
#'  \item{mathAge11}{score on math at age 11}
#'  \item{mathAge8}{score on math at age 8}
#'  \item{gender}{gender, a factor with 2 levels (F, M)}
#'  \item{class}{father's social class, a factor with 2 levels (manual, nonmanual)}
#'  \item{school}{school code (1-50)}
#'  \item{normAge11}{normalized score on math at age 11}
#'  \item{normAge8}{normalized score on math at age 8}
#'  \item{schoolMathAge8}{average school math score}
#'  \item{mathAge8c}{centered math score at age 8}
#' }
#' 
#' @docType data
#' @keywords datasets
#' @name jsp728
#' @usage data(jsp728)
#' @source \url{http://www.bristol.ac.uk/cmm/team/hg/msm-3rd-ed/datasets.html}
#' @references 
#'   Goldstein, H. (2011). Multilevel Statistical Models (4th ed.). Hoboken: Wiley
NULL