% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.lmvar_no_fit.R
\name{alias.lmvar_no_fit}
\alias{alias.lmvar_no_fit}
\title{Aliased coefficients in an 'lmvar' object}
\usage{
\method{alias}{lmvar_no_fit}(object, mu = TRUE, sigma = TRUE, ...)
}
\arguments{
\item{object}{Object of class 'lmvar_no_fit' (hence it can also be of class 'lmvar')}

\item{mu}{Boolean, specifies whether the aliased columns from the model matrix \eqn{X_\mu} must be returned}

\item{sigma}{Boolean, specifies whether the aliased columns from the model matrix \eqn{X_\sigma} must be returned}

\item{...}{Additional arguments, not used in the current implementation}
}
\value{
A character vector containing the names of the aliased columns
}
\description{
Returns the columns present in the user-specified model-matrices \eqn{X_\mu} and \eqn{X_\sigma} that were removed by
\code{lmvar} to make the matrices full-rank.
}
\details{
If \code{mu = TRUE} and \code{sigma = TRUE}, the function returns the aliased columns of both \eqn{X_\mu}
and \eqn{X_\sigma}. The string "_s" is appended to the aliased column names from \eqn{X_\sigma} if at least one of those
names also appears in \eqn{X_\mu}

If \code{mu = TRUE} and \code{sigma = FALSE}, the function returns the aliased columns of \eqn{X_\mu}.

If \code{mu = FALSE} and \code{sigma = TRUE}, the function returns the aliased columns of \eqn{X_\sigma}.
}
\examples{
# Create matrix columns
my_intercept = rep(1, 20)
v1 = c(rep(1, 10), rep(0, 10))
v2 = c(rep(0, 10), rep(1, 10))

# Create model matrices
X = cbind(my_intercept, v1, v2)
X_s = X

# Rename the last column of the model matrix 'X_s' to make this example more clear.
colnames(X_s)[3] = "v3"

# Create response vector
y = rnorm(20)

# Perform fit
fit = lmvar(y, X, X_s)

# The column 'my_intercept' is identical to '(Intercept)' added by 'lmvar'
# to the model matrix 'X'. Column 'v2' is equal to '(Intercept)' minus 'v1'.
# The same holds for the model matrix 'X_s'.
alias(fit)

# The aliased columns are left out if you extract the coefficients from a summary
coef(summary(fit))

# Only return the aliased colums in the model matrix for the expectation values
alias(fit, sigma = FALSE)

# Only return the aliased colums in the model matrix for the standard deviations
alias(fit, mu = FALSE)

# It also works on an object of class 'lmvar_no_fit'
no_fit = lmvar_no_fit(y, X, X_s)
alias(no_fit, mu = FALSE)
}
