% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/golem_utils_ui.R
\name{menu.idioma}
\alias{menu.idioma}
\title{#' Include Content From a File
#' 
#' Load rendered RMarkdown from a file and turn into HTML.
#' 
#' @rdname includeRMarkdown
#' @export
#' 
#' @importFrom rmarkdown render
#' @importFrom markdown markdownToHTML
#' @importFrom shiny HTML
includeRMarkdown <- function(path){
  
  md <- tempfile(fileext = '.md')
  
  on.exit(unlink(md),add = TRUE)
  
  rmarkdown::render(
    path,
    output_format = 'md_document',
    output_dir = tempdir(),
    output_file = md,quiet = TRUE
    )
  
  html <- markdown::markdownToHTML(md, fragment.only = TRUE)
  
  Encoding(html) <- "UTF-8"
  
  return(HTML(html))
}
HTML for language menu.}
\usage{
menu.idioma()
}
\value{
An HTML element.
}
\description{
#' Include Content From a File
#' 
#' Load rendered RMarkdown from a file and turn into HTML.
#' 
#' @rdname includeRMarkdown
#' @export
#' 
#' @importFrom rmarkdown render
#' @importFrom markdown markdownToHTML
#' @importFrom shiny HTML
includeRMarkdown <- function(path){
  
  md <- tempfile(fileext = '.md')
  
  on.exit(unlink(md),add = TRUE)
  
  rmarkdown::render(
    path,
    output_format = 'md_document',
    output_dir = tempdir(),
    output_file = md,quiet = TRUE
    )
  
  html <- markdown::markdownToHTML(md, fragment.only = TRUE)
  
  Encoding(html) <- "UTF-8"
  
  return(HTML(html))
}
HTML for language menu.
}
\examples{
menu.idioma()

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
