% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rMethods.R
\name{scoreSequences2probabilityVector}
\alias{scoreSequences2probabilityVector}
\title{Empirical distribution from sequences}
\usage{
scoreSequences2probabilityVector(sequences)
}
\arguments{
\item{sequences}{list of numerical sequences}
}
\value{
empirical distribution from minimum score to maximum score as a vector of floating numbers.
}
\description{
Builds empirical distribution from a list of numerical sequences
}
\details{
By determining the extreme scores in the sequences, this function creates a vector of probabilities
including values that do not occur at all. In this it differs from table(). For example, two sequences containing
values from 1:2 and 5:6 will produce a vector of size 6.
}
\examples{
seq1 = sample(7:8, size = 10, replace = TRUE)
seq2 = sample(2:3, size = 15, replace = TRUE)
l = list(seq1, seq2)
scoreSequences2probabilityVector(l)
}
