% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectreg_loclin_bivariate.R
\name{expectreg_loclin_bivariate}
\alias{expectreg_loclin_bivariate}
\title{Local linear expectile regression (iterative procedure) for
a bivariate covariate case}
\usage{
expectreg_loclin_bivariate(
  Z1,
  Z2,
  Y,
  omega,
  kernel = gaussK,
  h,
  grid = cbind(seq(min(Z1), max(Z1), length.out = length(Z1)), seq(min(Z2), max(Z2),
    length.out = length(Z2)))
)
}
\arguments{
\item{Z1}{The first covariate data values.}

\item{Z2}{The second covariate data values.}

\item{Y}{The response data values.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{h}{Smoothing parameter, bandwidth.}

\item{grid}{Matrix of evaluation points. In default setting, a grid of
equispaced grid-values on the domain of the variables \code{Z1} and \code{Z2}.}
}
\value{
\code{\link{expectreg_loclin_bivariate}} local linear expectile estimator
proposed and studied by Adam and Gijbels (2021b) for a bivariate covariate case.
\code{\link{expectreg_loclin_bivariate}} returns a matrix whose components are
the estimation of the bivariate expectile surface, of order \eqn{\omega} according to the grid matrix.
The rows are the grid on the first covariate data values (i.e. \code{Z1})
and the columns the grid on the second covariate data values (i.e. \code{Z2}).
}
\description{
Formula interface for the local linear expectile estimation
for a bivariate covariate case.
}
\examples{
library(locpol)
library(lestat)
set.seed(6)
dist <- muniformdistribution(rep(0, 2), rep(1, 2))
values<-simulate(dist,200)
Z_1<-values[,1]
Z_2<-values[,2]
Z<-rbind(Z_1,Z_2)
gamma=cbind(3,-0.4)
set.seed(7)
eta_1<-rnorm(100,0,1)
X1=(gamma\%*\%Z)+(1.5*eta_1)
set.seed(8)
eta_2<-rnorm(100,0,2)
X2=(gamma\%*\%Z)+(1.5*eta_2)
X<-rbind(X1,X2)
set.seed(9)
epsilon<-rt(100,3)
delta_true<-rbind(0,-0.8)
Y=as.numeric((t(delta_true)\%*\%X)+(0.2*exp(1.5*(gamma\%*\%Z)))+epsilon)

expectreg_loclin_bivariate(Z1=Z_1,Z2=Z_2,Y=Y,omega=0.1
,kernel=gaussK,h=0.1,grid=cbind(seq(min(Z_1),max(Z_1)
,length.out=10),seq(min(Z_2),max(Z_2),length.out=10)))

}
\references{
{

Adam, C. and Gijbels, I. (2021b). Partially linear expectile regression using
local polynomial fitting. In Advances in Contemporary Statistics and Econometrics:
Festschrift in Honor of Christine Thomas-Agnan, Chapter 8, pages 139–160. Springer, New York.

}
}
