% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiRR.R
\name{multiRR}
\alias{multiRR}
\title{Inference on relative risk under multinomial logistic regression}
\usage{
multiRR(formula, basecov = 0, fixcov = NULL, data, boot = FALSE,
  n.boot = 100)
}
\arguments{
\item{formula}{a formula term that is passed into \code{multinom()} where response should be a factor having \code{K} different levels. Every term appearing in the formula should be well-defined as a column of \code{data}. Reference response should be specified as the first level.}

\item{basecov}{a baseline value of exposure variable. Defaults to \code{0}.}

\item{fixcov}{a data frame of fixed value for each of adjusted confounders. If there is no confounder other than the exposure variable of interest, \code{fixcov} = \code{NULL}; if \code{fixcov} is missing for existing covariates, they are all set to \code{0} (for numerical covariates) or to the first level (for factor covariates).}

\item{data}{a data frame containing response variable and all the terms used in \code{formula}.}

\item{boot}{a logical value whether bootstrap samples are generated or not. Defaults to \code{FALSE}.}

\item{n.boot}{if \code{boot =  TRUE}, the number of bootstrap samples. Defaults to \code{100}.}
}
\value{
\item{\code{fit}}{an object of class \code{multinom}.}
\item{\code{RRR}}{(adjusted) relative risk ratio of \code{K} different responses compared to reference response under exposure at baseline (\code{basecov}) and \code{basecov + 1}.}
\item{\code{RR}}{(adjusted) relative risk of \code{K} different responses under exposure at baseline (\code{basecov}) and \code{basecov + 1}.}
\item{\code{delta.var}}{estimated variance of relative risk (\code{RR}) using Delta method.}
\item{\code{boot.rr}}{if \code{boot = TRUE}, a vector of \code{RR}'s using bootstrap samples.}
\item{\code{boot.rrr}}{if \code{boot = TRUE}, a vector of relative risk ratio (\code{RRR})'s using bootstrap samples.}
\item{\code{boot.var}}{estimated sampled variance using bootstraps if \code{boot = TRUE}.}
\item{\code{fix.cov}}{a data frame of fixed value for each of adjsuted confounders.}
}
\description{
Inference on relative risk under multinomial logistic regression
}
\examples{
n <- 500
set.seed(1234)
X <- rbinom(n, 1, 0.3)
W <- rbinom(n, 1, 0.3)
W[sample(1:n, n/3)] = 2
Y <- rbinom(n, 1, plogis(X - W))
dat <- as.data.frame(cbind(Y, X, W))
result <- multiRR(W ~ X + Y, basecov = 0, data = dat, boot = TRUE, n.boot = 100)
print(apply(result$boot.rr, 2, sd)) # estimated standard errors using Delta method
print(sqrt(result$delta.var)) # estimated standard errors using bootstrap

}
\author{
Youjin Lee
}
