% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{yogurt}
\alias{yogurt}
\title{Choice observations of yogurt purchases by 100 households}
\format{
\tabular{ll}{
   Variable \tab Description \cr
   \code{id} \tab individual identifiers \cr
   \code{obsID} \tab identifier for unique choice observation \cr
   \code{alt} \tab alternative in each choice observation \cr
   \code{choice} \tab dummy code for choice (1 or 0) \cr
   \code{price} \tab price of yogurt \cr
   \code{feat} \tab dummy for whether a newspaper advertisement was shown to the customer (\code{1} or \code{0}) \cr
   \code{brand} \tab yogurt brand: \code{"yoplait"}, \code{"dannon"}, \code{"hiland"}, or \code{"weight"} (for weight watcher) \cr
   \code{dannon} \tab dummy variable for the \code{"dannon"} brand (\code{1} or \code{0}) \cr
   \code{hiland} \tab dummy variable for the \code{"hiland"} brand (\code{1} or \code{0}) \cr
   \code{weight} \tab dummy variable for the \code{"weight"} brand (\code{1} or \code{0}) \cr
   \code{yoplait} \tab dummy variable for the \code{"yoplait"} brand (\code{1} or \code{0}) \cr
}
}
\source{
Raw data downloaded from the package mlogit v0.3-0 by Yves
Croissant \href{https://www.rdocumentation.org/packages/mlogit/versions/0.3-0/topics/Yogurt}{archive}
}
\usage{
data(yogurt)
}
\description{
Data from Jain et al. (1994) containing 2,412 choice observations from a
series of yogurt purchases by a panel of 100 households in Springfield,
Missouri, over a roughly two-year period. The data were collected by
optical scanners and contain information about the price, brand, and a
"feature" variable, which identifies whether a newspaper advertisement was
shown to the customer. There are four brands of yogurt: Yoplait, Dannon,
Weight Watchers, and Hiland, with market shares of 34\%, 40\%, 23\% and 3\%,
respectively.
}
\examples{
data(yogurt)

head(yogurt)
}
\references{
Dipak C. Jain, Naufel J. Vilcassim & Pradeep K. Chintagunta (1994) A Random-Coefficients Logit Brand-Choice Model Applied to Panel Data, Journal of Business & Economic Statistics, 12:3, 317-328,
\doi{10.1080/07350015.1994.10524547}
}
\keyword{datasets}
