% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictChoices}
\alias{predictChoices}
\title{Predict choices}
\usage{
predictChoices(model, alts, altID, obsID = NULL)
}
\arguments{
\item{model}{The output of a model estimated model using the \code{logitr()}
function.
Include if you want to compare true choices from actual observations (e.g.
hold outs) to the predicted choices.}

\item{alts}{A data frame of a set of alternatives for which to predict
choices. Each row is an alternative and each column an attribute
corresponding to parameter names in the estimated model.}

\item{altID}{The name of the column that identifies each alternative
in each set of alternatives.}

\item{obsID}{The name of the column that identifies each set of
alternatives. Required if predicting results for more than one set of
alternatives. Defaults to \code{NULL} (for a single set of alternatives).}
}
\value{
A data frame with the predicted choices for each alternative in
\code{alts}.
}
\description{
Returns the expected choices for a set of one or more alternatives based
on the results from an estimated model.
}
\keyword{choice}
\keyword{internal}
\keyword{logitr}
\keyword{predict}
\keyword{simulation}
