% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{model.frame.logitr}
\alias{model.frame.logitr}
\title{Extracting the Model Frame from a Formula or Fit}
\usage{
\method{model.frame}{logitr}(formula, ...)
}
\arguments{
\item{formula}{a model \code{formula} or \code{terms} object or an R object.}

\item{...}{further arguments.}
}
\value{
A data.frame with the variables needed to use formula and
any \code{...} arguments.
}
\description{
Returns a data.frame with the variables needed to use formula and
any \code{...} arguments.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Get the model.frame data frame
model.frame(mnl_pref)
}
\keyword{logitr}
\keyword{model.frame}
