% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognorm-package.R
\docType{package}
\name{lognorm-package}
\alias{lognorm}
\alias{lognorm-package}
\title{lognorm: Functions for the Lognormal Distribution}
\description{
The lognormal distribution  
  (Limpert et al. (2001) <doi:10.1641/0006-3568(2001)051%5B0341:lndats%5D2.0.co;2>)
  can characterize uncertainty that is bounded by zero.
  This package provides estimation of distribution parameters, computation of
  moments and other basic statistics, and an approximation of the distribution
  of the sum of several correlated lognormally distributed variables 
  (Lo 2013 <doi:10.12988/ams.2013.39511>) and the approximation of the 
  difference of two correlated lognormally distributed variables
  (Lo 2012 <doi:10.1155/2012/838397>).
}
\details{
Essential functions are 

\itemize{
\item Compute summary statistics: 
  \code{\link{getLognormMoments}}
\item computing distribution parameters from summary statistics: 
  \code{\link{getParmsLognormForModeAndUpper}}
\item estimate distribution parameters from summary sample: 
  \code{\link{estimateParmsLognormFromSample}}
\item Approximate the sum of correlated lognormals: 
  \code{\link{estimateSumLognormalSample}}
\item Approximate the difference of two correlated lognormals: 
  \code{\link{estimateDiffLognormal}}
}

Utilities for correlated data. These functions maybe moved to
a separate package in future.
\itemize{
\item Estimate summary statistics of autocorrelated data
\itemize{
  \item standard error of the mean: \code{\link{seCor}} 
  \item effective number of observations \code{\link{computeEffectiveNumObs}} 
  \item variance: \code{\link{varCor}} 
  }
\item Return the vector of effective components of the autocorrelation: 
  \code{\link{computeEffectiveAutoCorr}} 
}

Otherwise refer to the vignettes
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bgctw/lognorm}
}

}
\keyword{internal}
