% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R, R/plots.R
\name{autoplot.elife_par}
\alias{autoplot.elife_par}
\alias{plot.elife_par}
\title{Goodness-of-fit plots for parametric models}
\usage{
autoplot.elife_par(object, ...)

\method{plot}{elife_par}(
  x,
  plot.type = c("base", "ggplot"),
  which.plot = c("pp", "qq"),
  confint = c("none", "pointwise", "simultaneous"),
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{elife_par} containing the fitted parametric model}

\item{...}{additional arguments, currently ignored by the function.}

\item{x}{a parametric model of class \code{elife_par}}

\item{plot.type}{string, one of \code{base} for base R or \code{ggplot}}

\item{which.plot}{vector of string indicating the plots, among \code{pp} for probability-probability plot, \code{qq} for quantile-quantile plot, \code{erp} for empirically rescaled plot (only for censored data), \code{exp} for standard exponential quantile-quantile plot or \code{tmd} for Tukey's mean difference plot, which is a variant of the Q-Q plot in which we map the pair \eqn{(x,y)} is mapped to \code{((x+y)/2,y-x)} are detrended, \code{dens} and \code{cdf} return the empirical distribution function with the fitted parametric density or distribution function curve superimposed.}

\item{confint}{logical; if \code{TRUE}, creates uncertainty diagnostic via a parametric bootstrap}

\item{plot}{logical; if \code{TRUE}, creates a plot when \code{plot.type="ggplot"}. Useful for returning \code{ggplot} objects without printing the graphs}
}
\value{
The function produces graphical goodness-of-fit plots using base R or ggplot objects (returned as an invisible list).
}
\description{
Because of censoring and truncation, the plotting
positions must be adjusted accordingly.
For right-censored data, the methodology is described
in Waller & Turnbull (1992). Only non-censored observations are
displayed, which can create distortion.
}
\details{
For truncated data, we first estimate the distribution function
nonparametrically, \eqn{F_n}. The uniform plotting positions of the data
\deqn{v_i = [F_n(y_i) - F_n(a_i)]/[F_n(b_i) - F_n(a_i)].}
For probability-probability plots, the empirical quantiles are transformed
using the same transformation, with \eqn{F_n} replaced by the postulated or estimated
distribution function \eqn{F_0}.
For quantile-quantile plots, the plotting positions \eqn{v_i} are mapped back
to the data scale viz. \deqn{F_0^{-1}\{F_0(a_i) + v_i[F_0(b_i) - F_0(a_i)]\}}
When data are truncated and observations are mapped back to the untruncated scale (with, e.g., \code{exp}), the plotting positions need not be in the same order as the order statistics of the data.
}
\examples{
set.seed(1234)
samp <- samp_elife(
 n = 200,
 scale = 2,
 shape = 0.3,
 family = "gomp",
 lower = 0, upper = runif(200, 0, 10),
 type2 = "ltrc")
fitted <- fit_elife(
 time = samp$dat,
 thresh = 0,
 event = ifelse(samp$rcens, 0L, 1L),
 type = "right",
 family = "exp",
 export = TRUE)
plot(fitted, plot.type = "ggplot")
# Left- and right-truncated data
n <- 40L
samp <- samp_elife(
 n = n,
 scale = 2,
 shape = 0.3,
 family = "gp",
 lower = ltrunc <- runif(n),
 upper = rtrunc <- ltrunc + runif(n, 0, 15),
 type2 = "ltrt")
fitted <- fit_elife(
 time = samp,
 thresh = 0,
 ltrunc = ltrunc,
 rtrunc = rtrunc,
 family = "gp",
 export = TRUE)
plot(fitted,  which.plot = c("tmd", "dens"))
}
