% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/waic.R
\name{waic}
\alias{waic}
\alias{waic.function}
\alias{waic.matrix}
\title{Widely applicable information criterion (WAIC)}
\usage{
waic(x, ...)

\method{waic}{matrix}(x, ...)

\method{waic}{function}(x, ..., args)
}
\arguments{
\item{x}{A log-likelihood matrix or function. See the \strong{Methods (by
class)} section below for a detailed description.}

\item{...}{Other arguments. Currently ignored.}

\item{args}{Only required if \code{x} is a function. A list containing
the data required to specify the arguments to the function. See the
\strong{Methods (by class)} section below for how \code{args} should be
specified.}
}
\value{
A named list (of class \code{'loo'}) with components:

\describe{
\item{\code{elpd_waic, se_elpd_waic}}{expected log pointwise predictive
density and standard error}
\item{\code{p_waic, se_p_waic}}{estimated effective number of parameters and
standard error}
\item{\code{waic, se_waic}}{\code{-2 * elpd_waic} (i.e., converted to the
deviance scale) and standard error}
\item{\code{pointwise}}{the pointwise contributions of each of the above
measures}
}
}
\description{
Widely applicable information criterion (WAIC)
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: An \eqn{S} by \eqn{N} matrix, where \eqn{S} is the size of the posterior
sample (the number of simulations) and \eqn{N} is the number of data points.
Typically (but not restricted to be) the object returned by
\code{\link{extract_log_lik}}.

\item \code{function}: A function \eqn{f} that takes arguments \code{i}, \code{data},
 and \code{draws} and returns a vector containing the log-likelihood for
 the \code{i}th observation evaluated at each posterior draw.

 The \code{args} argument must also be specified and should be a named list
 with the following components:
 \itemize{
   \item \code{draws}: An object containing the posterior draws for any
   parameters needed to compute the pointwise log-likelihood.
   \item \code{data}: An object containing data (e.g. observed outcome and
   predictors) needed to compute the pointwise log-likelihood. \code{data}
   should be in an appropriate form so that \eqn{f}\code{(i=i,
   data=data[i,,drop=FALSE], draws=draws)} returns the \code{S}-vector of
   log-likelihoods for the \code{i}th observation.
   \item \code{N}: The number of observations.
   \item \code{S}: The size of the posterior sample.
 }
}}
\examples{
\dontrun{
log_lik1 <- extract_log_lik(stanfit1)
waic1 <- waic(log_lik1)
waic1

log_lik2 <- extract_log_lik(stanfit2)
waic2 <- waic(log_lik2)
print(waic2, digits = 4)

waic_diff <- compare(waic1, waic2)
print(waic_diff, digits = 2)
}
}
\seealso{
\code{\link{compare}}, \code{\link{print.loo}},
\code{\link{loo-package}}
}

