% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot.R
\name{l_plot.default}
\alias{l_plot.default}
\title{The default \code{l_plot} for plotting data}
\usage{
\method{l_plot}{default}(x, y = NULL, color = "grey60",
  glyph = "ccircle", size = 4, active = TRUE, selected = FALSE,
  xlabel, ylabel, title, showLabels = TRUE, showScales = FALSE,
  showGuides = TRUE, guidelines = "white",
  guidesBackground = "grey92", foreground = "black",
  background = "white", parent = NULL, ...)
}
\arguments{
\item{x}{the \code{x} and \code{y} arguments provide the x and y
coordinates for the plot.
Any reasonable way of defining the coordinates is acceptable.
See the function \code{\link{xy.coords}} for details.
If supplied separately, they must be of the same length.}

\item{y}{argument description is as for the \code{x} argument above.}

\item{color}{colours of points (default "grey60"); colours are repeated
until matching the number points,}

\item{glyph}{shape of point; must be one of the primitive glyphs
"circle", "ccircle", "ocircle", "square", "csquare", "osquare", "triangle", "ctriangle",
"otriangle", "diamond", "cdiamond", or "odiamond". Prefixes "c" and "o" mean closed and open, respectively.
Default is "ccircle" meaning a closed circle glyph.

Non-primitive glyphs such as polygons, images, text, point ranges, and even interactive glyphs like
serial axes glyphs may be added, but only after the plot has been created.}

\item{size}{size of the symbol (roughly in terms of area)}

\item{active}{a logical determining whether points appear or not
(default is TRUE for all points). If a logical vector is given of length
equal to the number of points, then it identifies which points appear (TRUE)
and which do not (FALSE).}

\item{selected}{a logical determining whether points appear selected at first
(default is FALSE for all points). If a logical vector is given of length
equal to the number of points, then it identifies which points are (TRUE)
and which are not (FALSE).}

\item{xlabel}{Label for the horizontal (x) axis. If missing,
one will be inferred from \code{x} if possible.}

\item{ylabel}{Label for the vertical (y) axis. If missing,
one will be inferred from \code{y} (or \code{x}) if possible.}

\item{title}{Title for the plot, default is an empty string.}

\item{showLabels}{logical to determine whether axes label (and title) should
be presented.}

\item{showScales}{logical to determine whether numerical scales should
be presented on both axes.}

\item{showGuides}{logical to determine whether to present background guidelines
to help determine locations.}

\item{guidelines}{colour of the guidelines shown when \code{showGuides = TRUE} (default "white").}

\item{guidesBackground}{colour of the background to the guidelines shown when
\code{showGuides = TRUE} (default "grey92").}

\item{foreground}{foreground colour used by all other drawing (default "black").}

\item{background}{background colour used for the plot (default "white")}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}

\item{...}{named arguments to modify plot states.}
}
\description{
Creates an interactive 2d scatterplot. Also, if no loon
  inspector is open then the \code{l_plot} call will also open a loon
  inspector.
}
\details{
The scatterplot displays a number of direct interactions with the
  mouse and keyboard, these include: zooming towards the mouse cursor using
  the mouse wheel, panning by right-click dragging and various selection
  methods using the left mouse button such as sweeping, brushing and
  individual point selection. See the documentation for \code{\link{l_plot}}
  for more details about the interaction gestures.
}
\examples{

# default use as scatterplot

p1 <- with(iris, l_plot(Sepal.Length, Sepal.Width, color=Species,
                        title = "First plot"))

# The names of the info states that can be
# accessed or set.  They can also be given values as
# arguments to l_plot.default()
names(p1)
p1["size"] <- 10

p2 <- with(iris, l_plot(Petal.Length ~ Petal.Width,
                        linkingGroup="iris_data",
                        title = "Second plot",
                        showGuides = FALSE))
p2["showScales"] <- TRUE

# link first plot with the second plot requires
# l_configure to coordinate the synchroniztion
l_configure(p1, linkingGroup = "iris_data", sync = "push")

p1['selected'] <- iris$Species == "versicolor"
p2["glyph"][p1['selected']] <- "cdiamond"

gridExtra::grid.arrange(loonGrob(p1), loonGrob(p2), nrow = 1)


# Use with other tk widgets
tt <- tktoplevel()
tktitle(tt) <- "Loon plots with custom layout"

p1 <- l_plot(parent=tt, x=c(1,2,3), y=c(3,2,1))
p2 <- l_plot(parent=tt, x=c(4,3,1), y=c(6,8,4))

tkgrid(p1, row=0, column=0, sticky="nesw")
tkgrid(p2, row=0, column=1, sticky="nesw")

tkgrid.columnconfigure(tt, 0, weight=1)
tkgrid.columnconfigure(tt, 1, weight=1)

tkgrid.rowconfigure(tt, 0, weight=1)

}
\seealso{
\code{\link{l_plot_arguments}}

Other two-dimensional plotting functions: \code{\link{l_plot.decomposed.ts}},
  \code{\link{l_plot.density}}, \code{\link{l_plot.stl}},
  \code{\link{l_plot}}

Other loon interactive states: \code{\link{l_info_states}},
  \code{\link{l_plot}}, \code{\link{l_state_names}},
  \code{\link{names.loon}}
}
\concept{loon interactive states}
\concept{two-dimensional plotting functions}
