% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot3D.R
\name{l_scale3D}
\alias{l_scale3D}
\title{Scale for 3d plotting}
\usage{
l_scale3D(x, center = TRUE, method = c("box", "sphere"))
}
\arguments{
\item{x}{the matrix or data.frame whose columns are to be scaled.}

\item{center}{either a logical value or numeric-alike vector of length equal
to the number of columns of x, where ‘numeric-alike’ means that as.numeric(.)
will be applied successfully if is.numeric(.) is not true.}

\item{method}{the scaling method to use: if "box" (the default) then the columns are scaled to
have equal ranges; if "sphere" then x is centered, scaled to equal standard deviation and then
decomposed via a singular value decomposition so that the resulting variables are uncorrelated.}
}
\value{
a data.frame whose columns are centred and scaled according to the given arguments.
}
\description{
\code{l_scale3D} scales its argument in a variety of ways used for 3D visualization.
}
\examples{

##### Iris
with(l_scale3D(iris[,1:4]),
     l_plot3D(Petal.Length, Petal.Width, Sepal.Length, linkingGroup = "iris"))

with(l_scale3D(iris[,1:4], method = "sphere"),
     l_plot3D(pc1, pc2, pc3, linkingGroup = "iris"))

# With the Species as a factor

with(l_scale3D(iris),
     l_plot3D(Petal.Length, Petal.Width, Sepal.Length, linkingGroup = "iris"))

with(l_scale3D(iris, method = "sphere"),
     l_plot3D(pc1, pc2, pc3, linkingGroup = "iris"))

}
\seealso{
\code{\link{l_plot3D}} \code{\link{scale}}

Other three-dimensional plotting functions: \code{\link{l_plot3D.default}},
  \code{\link{l_plot3D}}
}
\concept{three-dimensional plotting functions}
