% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thetaEst.R
\name{lotriEst}
\alias{lotriEst}
\title{Extract or remove lotri estimate data frame from lotri object}
\usage{
lotriEst(x, drop = FALSE)
}
\arguments{
\item{x}{lotri object}

\item{drop}{boolean indicating if the lotri estimate should be dropped}
}
\value{
data frame with estimates or NULL if there is not a data.frame attached
}
\description{
Extract or remove lotri estimate data frame from lotri object
}
\examples{

fix1 <- lotri({
   a <- c(0, 1); backTransform("exp"); label("a label")
   b <- c(0, 1, 2)
   c <- fix(1)
   d <- fix(0, 1, 2)
   e <- c(0, 1, 2, fixed)
   f+g ~ c(1,
           0.5, 1)
 })

# Extract the attached lotri estimate data frame
lotriEst(fix1)

# Remove the attached lotri estimate data frame
lotriEst(fix1, drop=TRUE)

}
