% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpdensity-package.R
\docType{package}
\name{lpdensity-package}
\alias{lpdensity-package}
\alias{_PACKAGE}
\title{lpdensity: Local Polynomial Density Estimation and Inference}
\description{
Without imposing stringent distributional assumptions or shape restrictions,
  nonparametric density estimation has been popular in economics and other social
  sciences for counterfactual analysis, program evaluation, and policy recommendations.
  This package implements a novel density estimator based on local polynomial
  regression, documented in Cattaneo, Jansson and Ma (2017): \code{\link{lpdensity}}
  to construct local polynomial based density estimator; \code{\link{lpbwdensity}}
  to perform data-driven bandwidth selection; and \code{\link{lpdensity.plot}} for
  density plot with robust confidence interval.
  For more details, and related \code{Stata}
  and \code{R} packages useful for nonparametric data analysis  and statistical inference,
  visit \url{https://sites.google.com/site/nppackages}.
}
\references{
M. D. Cattaneo, M. Jansson and X. Ma. (2017). \href{http://www-personal.umich.edu/~cattaneo/papers/Cattaneo-Jansson-Ma_2017_LocPolDensity.pdf}{Simple Local Regression Distribution Estimators}. Working Paper, University of Michigan.
}
\author{
Matias D. Cattaneo, University of Michigan. \email{cattaneo@umich.edu}.

Michael Jansson, University of California, Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of Michigan. \email{xinweima@umich.edu}.
}
