# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @name get_vals_lagcrit
#' @title Compute values for lag length criterion
#' @description Compute values for 'AICc', 'AIC', or 'BIC'.
#'
#' @param y List with left (endogenous) variables.
#' @param x List with right (exogenous) variables.
#' @param lag_crit Integer: 'AICc'= 1, 'AIC' = 2, 'BIC' = 3.
#' @param h Integer.
#' @param k Integer.
#' @param max_lags Integer.
#' @keywords internal
NULL

get_vals_lagcrit <- function(y, x, lag_crit, h, k, max_lags) {
    .Call(`_lpirfs_get_vals_lagcrit`, y, x, lag_crit, h, k, max_lags)
}

#' @name hp_filter
#' @title Decompose a times series via the Hodrick-Prescott filter
#' @description  Estimates cyclical and trend component with HP-filter by Hodrick and Prescott (1997).
#' The function is based on the function \emph{hpfilter} from the package \emph{mFilter} by Mehmet Balcilar.
#' @param x Column matrix with numeric values.
#' @param lambda Numeric value.
#' @references
#' Hodrick, R.J., and Prescott, E. C. Prescott (1997) "Postwar U.S. Business Cycles: An Empirical Investigation."
#' \emph{Journal of Money, Credit and Banking}, 29(1), 1-16.
hp_filter <- function(x, lambda) {
    .Call(`_lpirfs_hp_filter`, x, lambda)
}

#' @name newey_west
#' @title Compute OLS parameters and robust standard errors based on Newey-West estimator
#' @description  Compute OLS parameters and robust standard errors based on Newey and West (1987).
#' The function is based on the Matlab code by James P. LeSage.
#' @param y Numeric vector.
#' @param x Numeric matrix.
#' @param h Integer.
#' @keywords internal
#' @references
#' Newey W.K., and West K.D. (1987). “A Simple, Positive-Definite, Heteroskedasticity and
#' Autocorrelation Consistent Covariance Matrix.” \emph{Econometrica}, 55, 703–708.
newey_west <- function(y, x, h) {
    .Call(`_lpirfs_newey_west`, y, x, h)
}

