% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lin_irfs.R
\name{plot_lin_irfs}
\alias{plot_lin_irfs}
\title{Compute and display plots of linear impulse responses}
\usage{
plot_lin_irfs(results_lin)
}
\arguments{
\item{results_lin}{A \link{list}() with 3D arrays estimated in \link{lp_lin}.}
}
\value{
A list with (gg-)plots for linear impulse responses.
}
\description{
Compute and display linear impulse responses estimated with \link{lp_lin}.
}
\examples{
\donttest{
# Load package
  library(lpirfs)

# Load data
  data_set_df <- interest_rules_var_data

# Estimate linear model
  results_lin <- lp_lin(data_set_df, lags_lin       = 4,
                                     lags_criterion = NaN,
                                     max_lags       = NaN,
                                     trend          = 0L,
                                     shock_type     = 1L,
                                     confint        = 1.96,
                                     hor            = 12)

# Make plots
  linear_plots <- plot_lin_irfs(results_lin)

# Show single plots
  linear_plots[[1]]
  linear_plots[[2]]

# Show all plots
  library(ggpubr)
  library(gridExtra)

  lin_plots_all <- sapply(linear_plots, ggplotGrob)
  marrangeGrob(lin_plots_all, nrow = ncol(data_set_df), ncol = ncol(data_set_df), top = NULL)

 }
}
\author{
Philipp Adämmer
}
