% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{ftrunc}
\alias{ftrunc}
\title{Adjusted p-Values for Holm, Hochberg, and Hommel Procedures}
\usage{
ftrunc(p, test = "hommel", gamma = 1)
}
\arguments{
\item{p}{The raw p-values for elementary hypotheses.}

\item{test}{The test to use, e.g., "holm", "hochberg", or
"hommel" (default).}

\item{gamma}{The value of the truncation parameter. Defaults to 1
for the regular Holm, Hochberg, or Hommel procedure.}
}
\value{
A matrix of adjusted p-values.
}
\description{
Obtains the adjusted p-values for possibly truncated
Holm, Hochberg, and Hommel procedures.
}
\examples{

pvalues <- matrix(c(0.01,0.005,0.015,0.022, 0.02,0.015,0.010,0.023),
                  nrow=2, ncol=4, byrow=TRUE)
ftrunc(pvalues, "hochberg")

}
\references{
Alex Dmitrienko, Ajit C. Tamhane, and Brian L. Wiens.
General multistage gatekeeping procedures.
Biometrical Journal. 2008; 5:667-677.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
