% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kmsurv}
\alias{kmsurv}
\title{Kaplan-Meier Survival Probability Based on Pooled Sample}
\usage{
kmsurv(
  time = NA_real_,
  allocationRatioPlanned = 1,
  piecewiseSurvivalTime = 0L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L
)
}
\arguments{
\item{time}{A vector of analysis times at which to calculate the
Kaplan-Meier Survival Probability.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda1}{A vector of hazard rates for the event for the
active treatment group. One for each analysis time interval.}

\item{lambda2}{A vector of hazard rates for the event for the
control group. One for each analysis time interval.}

\item{gamma1}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout for the active
treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, or a vector of
hazard rates for piecewise exponential dropout for the control group.}
}
\value{
A vector of Kaplan-Meier survival probabilities at the
specified analysis times for piecewise exponential survival and
dropout distributions.
}
\description{
Obtains the limit of Kaplan-Meier estimate of the survival
probabilities based on the pooled sample.
}
\examples{
# Piecewise exponential survivals, and 5\% dropout by the end of
# 1 year.

kmsurv(t = c(2, 8), allocationRatioPlanned = 1,
       piecewiseSurvivalTime = c(0, 6),
       lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
       gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
