% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{fmodmix}
\alias{fmodmix}
\title{Adjusted p-Values for Modified Mixture Gatekeeping Procedures}
\usage{
fmodmix(
  p,
  family = NULL,
  serial,
  parallel,
  gamma,
  test = "hommel",
  exhaust = TRUE
)
}
\arguments{
\item{p}{The raw p-values for elementary hypotheses.}

\item{family}{The matrix of family indicators for the hypotheses.}

\item{serial}{The matrix of serial rejection set for the hypotheses.}

\item{parallel}{The matrix of parallel rejection set for the hypotheses.}

\item{gamma}{The truncation parameters for each family. The truncation
parameter for the last family is automatically set to 1.}

\item{test}{The component multiple testing procedure. Options include
"holm", "hochberg", or "hommel". Defaults to "hommel".}

\item{exhaust}{Whether to use alpha-exhausting component testing procedure
for the last family with active hypotheses. It defaults to \code{TRUE}.}
}
\value{
A matrix of adjusted p-values.
}
\description{
Obtains the adjusted p-values for the modified gatekeeping
procedures for multiplicity problems involving serial and parallel
logical restrictions.
}
\examples{

p = c(0.0194, 0.0068, 0.0271, 0.0088, 0.0370, 0.0018, 0.0814, 0.0066)
family = matrix(c(1, 1, 0, 0, 0, 0, 0, 0,
                  0, 0, 1, 1, 0, 0, 0, 0,
                  0, 0, 0, 0, 1, 1, 0, 0,
                  0, 0, 0, 0, 0, 0, 1, 1),
                nrow=4, byrow=TRUE)

serial = matrix(c(0, 0, 0, 0, 0, 0, 0, 0,
                  0, 0, 0, 0, 0, 0, 0, 0,
                  1, 0, 0, 0, 0, 0, 0, 0,
                  0, 1, 0, 0, 0, 0, 0, 0,
                  0, 0, 1, 0, 0, 0, 0, 0,
                  0, 0, 0, 1, 0, 0, 0, 0,
                  0, 0, 0, 0, 1, 0, 0, 0,
                  0, 0, 0, 0, 0, 1, 0, 0),
                nrow=8, byrow=TRUE)

parallel = matrix(0, 8, 8)
gamma = c(0.6, 0.6, 0.6, 1)
fmodmix(p, family, serial, parallel, gamma, test = "hommel", exhaust = TRUE)

}
\references{
Alex Dmitrienko, George Kordzakhia, and Thomas Brechenmacher.
Mixture-based gatekeeping procedures for multiplicity problems with
multiple sequences of hypotheses. Journal of Biopharmaceutical
Statistics. 2016; 26(4):758–780.

George Kordzakhia, Thomas Brechenmacher, Eiji Ishida, Alex Dmitrienko,
Winston Wenxiang Zheng, and David Fuyuan Li. An enhanced mixture method
for constructing gatekeeping procedures in clinical trials.
Journal of Biopharmaceutical Statistics. 2018; 28(1):113–128.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
