% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/questionnaire_gen.R
\name{questionnaire_gen}
\alias{questionnaire_gen}
\title{Generation of ordinal and continuous variables}
\usage{
questionnaire_gen(n_obs, cat_prop, cor_matrix, c_mean = NULL, c_sd = NULL,
  theta = FALSE)
}
\arguments{
\item{n_obs}{number of observations to generate.}

\item{cat_prop}{list of cumulative proportions for each item.}

\item{cor_matrix}{latent correlation matrix.}

\item{c_mean}{is a vector of population means for each continuous variable.}

\item{c_sd}{is a vector of population standard deviations for each continuous variable.}

\item{theta}{if \code{TRUE} will labeled the first continuous variable 'theta'.}
}
\description{
Creates a data frame of discrete and continuous variables based on 
a latent correlation matrix and marginal proportions.
}
\section{Details}{

\code{cat_prop} is a list where \code{length(cat_prop)} is the number of
items to be generated.  Each element of the list is a vector containing 
the marginal cumulative proportions for each category, summing to 1.  For
continuous items, the associated element in the list should be 1. 

\code{cor_matrix} is correlation matrix that is the same size as 
\code{length(cat_prop)}.  The correlations related to the correlation 
between variables on the latent scale. 

\code{c_mean and c_sd} are each vectors whose length is equal to the number of 
continuous variables as specified by \code{cat_prop}.  The default is to 
keep the continuous variables with mean zero and standard deviation of one.  

\code{theta} is a logical indicator that determines if the first continuous 
item should be labeled \emph{theta}. If \code{theta = TRUE} but there are no
continuous variables generated, an error will be returned.    

If \code{cat_prop} is a named list, those names will be used as variable names 
for the returned \code{data.frame}.  Generic names will be provided to the 
variables if \code{cat_prop} is not named.
}
\examples{
questionnaire_gen(n = 10, cat_prop = list(c(1), c(.25, .6, 1)), 
                  cor_matrix = matrix(c(1, .6, .6, 1), nrow = 2), 
                  c_mean = 2, c_sd = 1.5, theta = TRUE)

}

