% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.lsirm.R
\name{summary.lsirm}
\alias{summary.lsirm}
\title{Summary the result of LSIRM}
\usage{
\method{summary}{lsirm}(object, chain.idx = 1, estimate = "mean", CI = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{lsirm}.}

\item{chain.idx}{Numeric; Index of MCMC chain. Default is 1.}

\item{estimate}{Character; Specifies the type of posterior estimate to provide for beta parameters. Options are \code{"mean"}, \code{"median"}, or \code{"mode"}. Default is \code{"mean"}.}

\item{CI}{Numeric; The significance level for the highest posterior density interval (HPD) for the beta parameters. Default is 0.95.}

\item{\dots}{Additional arguments.}
}
\value{
\code{summary.lsirm} contains following elements. A print method is available.
\item{call}{R call used to fit the model.}
\item{coef}{Covariate coefficients posterior means.}
\item{mcmc.opt}{The number of mcmc iteration, burn-in periods, and thinning intervals.}
\item{map.inf}{Value of log maximum a posterior and iteration number which have log maximum a posterior.}
\item{BIC}{Numeric value with the corresponding Bayesian information criterion (BIC).}
\item{method}{Which model is fitted.}
\item{missing}{The assumed missing type. One of NA, "mar" and "mcar".}
\item{dtype}{Type of input data (Binary or Continuous).}
\item{ss}{Whether a model selection approach using the spike-slab prior is applied.}
}
\description{
\link{summary} is used to summary the result of LSIRM.
}
\examples{
\donttest{
# generate example item response matrix
data     <- matrix(rbinom(500, size = 1, prob = 0.5),ncol=10,nrow=50)

# 1PL LSIRM object
lsirm_result <- lsirm(data ~ lsirm1pl())
summary(lsirm_result)
}
}
