% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsmplot.lsm.R
\encoding{UTF-8}
\name{plot.lsm}
\alias{plot.lsm}
\title{Graphics  Method for \code{lsm}  Objects}
\usage{
\method{plot}{lsm}(
  x,
  type = c("scatter", "probability", "Logit", "odds"),
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  color = "red",
  size = 1.5,
  shape = 19,
  ...
)
}
\arguments{
\item{x}{The LSM model object.}

\item{type}{The type of plot to draw. Options are "scatter" for a scatter plot, "probability" for a probability plot, "Logit" for a plot related to logistic regression, and "odds" for a plot related to odds.}

\item{title}{The title of the plot.}

\item{xlab}{The label for the x-axis.}

\item{ylab}{The label for the y-axis.}

\item{color}{The color of the dots in the plot.}

\item{size}{The size of the dots in the plot.}

\item{shape}{The shape oof the dots in the plot.}

\item{...}{Additional graphical arguments to be passed to ggplot.}
}
\value{
Un objeto ggplot.
 following components:
}
\description{
Obtains graphics from a fitted \code{lsm} object.
}
\details{
Gráfico de regresión logística

The saturated model is characterized by the assumptions 1 and 2 presented in section 2.3 by Llinas (2006, ISSN:2389-8976).
}
\examples{
#library(lsm)

#1. AGE and Coronary Heart Disease (CHD) Status of 100 subjects:

# library(lsm)
# library(tidyverse)
# datos <- lsm::chdage
# attach(datos)
# modelo <- lsm(CHD ~ AGE, data=datos)
# plot(modelo, type = "scatter")
# plot(modelo, type = "scatter", title  = "Villalba-llinas lsm")
# plot(modelo, type = "probability", xlab = "Elainys")
# plot(modelo, type = "Logit", color = "blue")
# plot(modelo, type = "odds", size = 3)

}
\references{
[1] LLinás, H. J. (2006). Precisiones en la teoría de los modelos logísticos. Revista Colombiana de Estadística, 29(2), 239–265. https://revistas.unal.edu.co/index.php/estad/article/view/29310

[2] Hosmer, D.W., Lemeshow, S. and Sturdivant, R.X. (2013). Applied Logistic Regression, 3rd ed., New York: Wiley.

[3] Chambers, J. M. and Hastie, T. J. (1992). Statistical Models in S. Wadsworth & Brooks/Cole.
}
\author{
Jorge Villalba Acevedo [cre, aut], (Universidad Tecnológica de Bolívar, Cartagena-Colombia).
}
