% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tFrame.R
\name{tFrame}
\alias{tFrame}
\title{Transpose a data frame}
\usage{
tFrame(x)
}
\arguments{
\item{x}{The data frame to be transposed.}
}
\value{
The transposed data frame
}
\description{
Transposes a data frame, converting variables to cases and vice versa
}
\details{
The \code{tFrame} function is a convenience function that simply
transposes the input data frame and coerces the result back to a data frame.
Apart from a very small amount of exception handling, it is equivalent to
\code{as.data.frame(t(x))}. It exists simply because I sometimes find it
convenient when teaching statistics to discuss simple data handling before
going into details regarding coercion; similarly, since I generally have
students work with data frames before exposing them to matrices, it is
convenient to have a transpose function that returns a data frame as output.

Naturally, the \code{tFrame} function should only be used when it is
actually sensible to think of the cases of \code{x} as variables in their
own right. In real life I expect that this maps almost perfectly onto those
cases where \code{x} could be a matrix just as easily as a data frame, so
I don't believe that \code{tFrame} is useful in real world data analysis. It
is intended as a teaching tool.
}
\examples{
# Create a data frame that could sensibly be transposed...
Gf <- c(105, 119, 121, 98)   # fluid intelligence for 4 people
Gc <- c(110, 115, 119, 103)  # crystallised intelligence
Gs <- c(112, 102, 108, 99)   # speed of processing
dataset <- data.frame( Gf, Gc, Gs )
rownames(dataset) <- paste( "person", 1:4, sep="" )
print(dataset)

# Now transpose it...
tFrame( dataset )

}
\seealso{
\code{\link{t}}
}
