% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lua_mode.R
\name{lua_profile}
\alias{lua_profile}
\title{Get profiling data}
\usage{
lua_profile(flush = TRUE)
}
\arguments{
\item{flush}{If \code{TRUE}, clears the internal profile data buffer (default);
if \code{FALSE}, doesn't. (Set to \code{FALSE} if you want to 'peek' at the profiling
data collected so far, but you want to collect more data to add to this
later.)}
}
\value{
An object of class \code{"lua_profile"}.
}
\description{
After running Lua code with the profiler active (using \code{\link[=lua_mode]{lua_mode()}}), use
this function to get the profiling data that has been collected.
}
\details{
This function is experimental. Its interface and behaviour may change in
subsequent versions of luajr.
}
\examples{
\dontrun{
lua_mode(profile = TRUE)
pointless_computation = lua_func(
"function()
    local s = startval
    for i = 1,10^8 do
        s = math.sin(s)
        s = math.exp(s^2)
        s = s + 1
    end
    return s
end")
lua("startval = 100")
pointless_computation()
lua_mode(profile = FALSE)

prof = lua_profile()
}
}
\seealso{
\code{\link[=lua_mode]{lua_mode()}} for generating the profiling data.
}
