% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NeighbRasterStack.R
\docType{methods}
\name{NeighbRasterStack}
\alias{NeighbRasterStack}
\alias{NeighbRasterStack,RasterLayer,list,ANY-method}
\alias{NeighbRasterStack,RasterLayer,matrix,ANY-method}
\alias{NeighbRasterStack,RasterLayer,ANY,NeighbRasterStack-method}
\title{Create a NeighbRasterStack object}
\usage{
NeighbRasterStack(x, weights, neighb, ...)

\S4method{NeighbRasterStack}{RasterLayer,list,ANY}(x, weights, neighb,
  categories, fun = mean, ...)

\S4method{NeighbRasterStack}{RasterLayer,matrix,ANY}(x, weights, neighb,
  categories, fun = mean, ...)

\S4method{NeighbRasterStack}{RasterLayer,ANY,NeighbRasterStack}(x, weights,
  neighb)
}
\arguments{
\item{x}{RasterLayer containing categorical data}

\item{weights}{list containing a matrix of weights (the \code{w} argument in
\code{raster::\link[raster]{focal}}) for each land use category. The order
 of list or vector elements should correspond to the order of land use
 categories in \code{categories}}

\item{neighb}{NeighbRasterStack object. Only used if \code{categories} and
\code{weights} are not provided. This option can be useful when existing
NeighbRasterStack objects need to be updated because a new land use map is
available, such as during the allocation procedure.}

\item{\dots}{additional arguments to \code{raster::\link[raster]{focal}}}

\item{categories}{numeric vector containing land use categories for which
neighbourhood values should be calculated}

\item{fun}{function. Input argument to \code{focal}. Default is \code{mean}}
}
\value{
A NeighbRasterStack object.
}
\description{
Methods to calculate neighbourhood values for cells in raster maps using
\code{raster::\link[raster]{focal}}. By default the fraction of non-NA cells
within the moving window (i.e. the size of the weights matrix) devoted to each
land use category is calculated. This behaviour can be changed by altering the
weights matrix or providing an alternative function. The resulting object can
be used as the basis of neighbourhood decision rules.
}
\examples{

## Plum Island Ecosystems

## observed data
obs <- ObsLulcRasterStack(x=pie,
                    pattern="lu",
                    categories=c(1,2,3),
                    labels=c("forest","built","other"),
                    t=c(0,6,14))

## create a NeighbRasterStack object for 1985 land use map
w1 <- matrix(data=1, nrow=3, ncol=3, byrow=TRUE)
w2 <- w1
w3 <- w1

nb1 <- NeighbRasterStack(x=obs[[1]],
                 categories=c(1,2,3),
                 weights=list(w1,w2,w3))

## update nb2 for 1991
nb2 <- NeighbRasterStack(x=obs[[2]],
                  neighb=nb1)

## plot neighbourhood map for forest
plot(nb2[[1]])

}
\seealso{
\code{\link{NeighbRasterStack-class}}, \code{\link{allowNeighb}},
\code{raster::\link[raster]{focal}}
}
