% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{is_outlier}
\alias{is_outlier}
\title{Check whether value is outlier}
\usage{
is_outlier(x, na.rm = FALSE)
}
\arguments{
\item{x}{A numerical vector}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before the computation proceeds. Defaults to \code{FALSE}.}
}
\value{
A logical vector.
}
\description{
\code{is_outlier} returns a logical vector indicating whether a value is an
outlier based on the rule of 1.5 times the interquartile range above the
third quartile or below the first quartile.
}
\examples{
x <- c(1:8, NA, 15)
is_outlier(x, na.rm = TRUE)
}
\seealso{
\code{\link[stats:IQR]{stats::IQR()}},
\code{\link[stats:quantile]{stats::quantile()}}
}
