% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodetic.R
\name{lw_geodetic}
\alias{lw_geodetic}
\alias{st_geod_area}
\alias{lw_geodetic}
\alias{st_geod_length}
\alias{lw_geodetic}
\alias{st_geod_segmentize}
\alias{lw_geodetic}
\alias{st_geod_covers}
\title{liblwgeom geodetic functions}
\usage{
st_geod_area(x)

st_geod_length(x)

st_geod_segmentize(x, max_seg_length)

st_geod_covers(x, y)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{max_seg_length}{segment length in radians, or as a distance units}

\item{y}{object of class \code{sf}, \code{sfc} or \code{sfg}}
}
\description{
liblwgeom geodetic functions for length, area, segmentizing, covers
}
\examples{
library(sf)
nc = st_read(system.file("gpkg/nc.gpkg", package="sf"))
st_geod_area(nc[1:3,])
# st_area(nc[1:3,])
l = st_sfc(st_linestring(rbind(c(7,52), c(8,53))), crs = 4326)
st_geod_length(l)
library(units)
pol = st_polygon(list(rbind(c(0,0), c(0,60), c(60,60), c(0,0))))
x = st_sfc(pol, crs = 4326)
seg = st_geod_segmentize(x[1], set_units(10, km))
plot(seg, graticule = TRUE, axes = TRUE)
pole = st_polygon(list(rbind(c(0,80), c(120,80), c(240,80), c(0,80))))
pt = st_point(c(0,90))
x = st_sfc(pole, pt, crs = 4326)
st_geod_covers(x[c(1,1,1)], x[c(2,2,2,2)])
}
