% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FE_multidim_ind_computation.R
\name{alpha.fd.fe}
\alias{alpha.fd.fe}
\title{Compute the set of indices based on number of species in Functional Entities}
\usage{
alpha.fd.fe(
  asb_sp_occ,
  sp_to_fe,
  ind_nm = c("fred", "fored", "fvuln"),
  check_input = TRUE,
  details_returned = TRUE
)
}
\arguments{
\item{asb_sp_occ}{a matrix linking occurrences (coded as 0/1) of
species (columns) in a set of assemblages (rows). Warning: \strong{An
assemblage must contain at least one species}.}

\item{sp_to_fe}{a list with details of species clustering into FE
from \code{\link{sp.to.fe}}.}

\item{ind_nm}{a vector of character strings with the names of
functional diversity indices to compute among 'fred', 'fored' and 'fvuln'.
\bold{Indices names must be written in lower case letters}. Default: all
the indices are computed.}

\item{check_input}{a logical value indicating whether key features the
inputs are checked (e.g. class and/or mode of objects, names of rows
and/or columns, missing values). If an error is detected, a detailed
message is returned. Default: \code{check.input = TRUE}.}

\item{details_returned}{a logical value indicating whether details
about indices computation should be returned. These details are required
by \code{\link{alpha.fd.fe.plot}} to plot FEs indices.}
}
\value{
A list with:
\itemize{
\item \emph{asb_fdfe} a matrix containing for each assemblage (rows),
values of functional diversity indices (same names than in 'ind_nm')
as well as the number of species ('nb_sp') and the number of FE
(nb_fe);
\item if \emph{details_returned} is \code{TRUE},
\item \emph{details_fdfe} a list with \emph{asb_fe_nbsp} a matrix with
number of species per FE in each assemblage.
}
}
\description{
This function computes the set of indices based on number of species in
Functional Entities (FEs) following Mouillot \emph{et al.} (2014).
}
\examples{
# Load Species*Traits dataframe:
data('fruits_traits', package = 'mFD')

# Load Traits categories dataframe:
data('fruits_traits_cat', package = 'mFD')

# Load Assemblages*Species matrix:
data('baskets_fruits_weights', package = 'mFD')

# Remove continuous trait:
fruits_traits <- fruits_traits[, -5]
fruits_traits_cat <- fruits_traits_cat[-5, ]

# Compute gathering species into FEs:
sp_to_fe_fruits <- mFD::sp.to.fe(sp_tr = fruits_traits, 
 tr_cat = fruits_traits_cat, 
 fe_nm_type = 'fe_rank', check_input = TRUE)
 
# Get the occurrence dataframe:
asb_sp_fruits_summ <- mFD::asb.sp.summary(asb_sp_w = baskets_fruits_weights) 
asb_sp_fruits_occ <- asb_sp_fruits_summ$'asb_sp_occ'

# Compute alpha fd indices:
alpha.fd.fe(
   asb_sp_occ       = asb_sp_fruits_occ, 
   sp_to_fe         = sp_to_fe_fruits,
   ind_nm           = c('fred', 'fored', 'fvuln'),
   check_input      = TRUE, 
   details_returned = TRUE)
}
\references{
Mouillot \emph{et al.} (2014) Functional over-redundancy and high functional
vulnerability in global fish faunas on tropical reefs. \emph{PNAS}, \strong{38},
13757-13762.
}
\author{
Camille Magneville
}
