% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add-flags.R
\name{add_flags}
\alias{add_flags}
\title{Add Flag(s) To Messages}
\usage{
add_flags(imapconf, msg_id, by = "MSN", flags_to_set, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{flags_to_set}{A character vector containing one ore more flag names to
add to or replace in the specified message ids.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
An (invisible) \code{list} of length \code{2} containing the
    \code{imapconf} object and the previously inputed message ids
    (parameter \code{msg_id}).
}
\description{
Add one or more flags to one or more messages.
}
\note{
\link{add_flags}, \link{remove_flags} and \link{replace_flags}, accepts
    not only flags but also keywords (such as \code{$Phishing} on Gmail's
    IMAP server) to add, remove or replace.

IMAP servers do not allow setting the negative version of a flag when a
    message already has the positive version of it. If a message with
    \code{MSN 1} already has the "SEEN" flag, it is not allowed to add "UNSEEN"
    to that. Instead, you have to first remove the "SEEN" flag
    \code{remove_flags(imapconf, msg_id = 1, "SEEN")} and only then do
    \code{add_flags(imapconf, msg_id = 1, "SEEN")}. Another option is to
    complete override all the flags of a message or of a set of messages using
    \code{replace_flags(imapconf, msg_id = 1, "SEEN")}.
}
\examples{
\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                           username="your_gmail_user",
                           password=rstudioapi::askForPassword()
                          )

results <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    search_before(date_char = "10-may-2012", by = "UID") \%$\% #exposition pipe - two argg
    add_flags(imapconf = imapconf, msg_id = msg_id, flags_to_set = "RECENT")

}

}
\seealso{
Other miscellaneous: \code{\link{copy_msg}},
  \code{\link{count_msgs}}, \code{\link{delete_msg}},
  \code{\link{expunge}}, \code{\link{get_max_id}},
  \code{\link{get_min_id}}, \code{\link{move_msg}},
  \code{\link{remove_flags}}, \code{\link{replace_flags}}
}
\concept{miscellaneous}
