% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure-imap.R
\name{configure_imap}
\alias{configure_imap}
\title{IMAP Settings}
\usage{
configure_imap(url, username, password, show_pass = FALSE,
  use_ssl = TRUE, verbose = FALSE, buffersize = 16000,
  fresh_connect = FALSE, timeout_ms = 5000, ...)
}
\arguments{
\item{url}{String containing the IMAP server address}

\item{username}{String containing user's name.}

\item{password}{String containing user's password.}

\item{show_pass}{How to store user's password in imapconf object. Default is
\code{FALSE}.}

\item{use_ssl}{A Logical indicating the use or not of Secure Sockets Layer
encryption when connecting to IMAP server. Default is \code{TRUE}.}

\item{verbose}{If \code{FALSE}, mutes the output from the server. Default is
\code{FALSE}.}

\item{buffersize}{The size in bytes for curl's receive buffer. Default is
16000 bytes or 16kb, which means it will use the default value of libcurl.
Maximum buffersize in libcurl documentation is 512kb (or 512000 bytes),
but curl package accepts 2147483647 bytes without returning errors.}

\item{fresh_connect}{If \code{TRUE}, opens a new curl connection for each
IMAP command to be executed. Default is \code{NULL}. Nonetheless, most of
mRpostman functions will set \code{fresh_connect = TRUE} for the retires
in case of an connection error.}

\item{timeout_ms}{Time in miliseconds (ms) to wait until a connection or a
command to be executed. Default is 5000ms (or 5 seconds). If a first
execution is frustated, an error handler in each function (depending on
\code{retires} value), will try to reconnect or re-execute the command.}

\item{...}{Further parameters added by mRpostman functions or IMAP parameters
listed in \code{curl::curl_options}. Only for advanced users.}
}
\value{
An object of class \code{imapconf} containing the settings
    needed to connect to the IMAP server.
}
\description{
Configure IMAP server settings.
}
\examples{
\dontrun{

# Gmail config example:
library(mRpostman)
imapconf <- configure_imap(url="imaps://imap.gmail.com",
                           username="your_gmail_user",
                           password=rstudioapi::askForPassword()
                          )
}
}
\references{
\url{https://curl.haxx.se/libcurl/c/CURLOPT_BUFFERSIZE.html}
}
\seealso{
Other config: \code{\link{config_handle}}
}
\concept{config}
