% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-msg-metadata.R
\name{fetch_msg_metadata}
\alias{fetch_msg_metadata}
\title{Fetch Message Metadata}
\usage{
fetch_msg_metadata(imapconf, msg_id, by = "MSN", metadata,
  write_to_disk = FALSE, keep_in_mem = TRUE, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{metadata}{A character vector or string specifying one or more items of
the metadata of a message to fetch. See \link{metadata_options}.}

\item{write_to_disk}{If \code{TRUE} writes fetch content of each message
to the disk as a text file in the working directory. Default is \code{FALSE}.}

\item{keep_in_mem}{If \code{TRUE} keeps a copy of fetch results as an
list in the R session when \code{write_to_disk = TRUE}. Default is
\code{FALSE}. It can only be set \code{TRUE} when
\code{write_to_disk = TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A \code{list} or/and text files containing the fetch results.
}
\description{
Fetch Metadata of one or more messages.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# fetching
results <- imapconf \%>\%
    select_mailbox(mbox = "INBOX") \%>\%
    search_sent_since(date_char = "26-Aug-2008") \%$\% #exposition pipe - two argg
    fetch_msg_metadata(imapconf, msg_id = msg_id, by = "UID",
                     metadata = c("INTERNALDATE", "UID", "ENVELOPE", "FLAGS",
                                 "RFC822.SIZE", "BODYSTRUCTURE"))

}

}
\seealso{
Other fetch: \code{\link{fetch_full_msg}},
  \code{\link{fetch_msg_header}},
  \code{\link{fetch_msg_text}}
}
\concept{fetch}
