% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/larger-than.R
\name{larger_than}
\alias{larger_than}
\title{Criterion constructor function to be combined in a custom search statement}
\usage{
larger_than(size, negate = FALSE)
}
\arguments{
\item{size}{An integer specifying the number of seconds to be used as
search criterion.}

\item{negate}{If \code{TRUE}, negates the search and seeks for "NOT SEARCH
CRITERIA". Default is \code{FALSE}.}
}
\description{
Criterion constructor function to be combined in a custom search statement
}
\examples{
\dontrun{
# select folder & search
con$select_folder(name = "INBOX")
# search for messages containing the string "XYZ@k-state.edu" in the
#   "FROM" field OR those that are LARGER than 512KB.
res <- con$search(request = OR(string(expr = "XYZ@k-state.edu",
                                      where = "FROM"),
                               larger_than(size = 512000)))
}

}
\seealso{
Other custom search: 
\code{\link{AND}()},
\code{\link{ImapCon}},
\code{\link{OR}()},
\code{\link{before}()},
\code{\link{flag}()},
\code{\link{older_than}()},
\code{\link{on}()},
\code{\link{sent_before}()},
\code{\link{sent_on}()},
\code{\link{sent_since}()},
\code{\link{since}()},
\code{\link{smaller_than}()},
\code{\link{string}()},
\code{\link{younger_than}()}
}
\concept{custom search}
