% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allConstructors.R
\name{saObj}
\alias{saObj}
\title{A Constructor for Objects of Class \code{sadObj} and \code{saeObj}}
\usage{
saObj(
  data,
  f,
  smallAreaMeans = NULL,
  s1 = NULL,
  s2 = NULL,
  cluster = NULL,
  include = NULL,
  auxiliaryWeights = NULL
)
}
\arguments{
\item{data}{See \code{"\linkS4class{saeObj}"}.}

\item{f}{a linear mixed effects formula, but see \bold{Value}.}

\item{smallAreaMeans}{See \code{"\linkS4class{saeObj}"}.}

\item{s1}{See \code{"\linkS4class{saeObj}"}.}

\item{s2}{See \code{"\linkS4class{saeObj}"}.}

\item{cluster}{See \code{"\linkS4class{saeObj}"}.}

\item{include}{See \code{"\linkS4class{saeObj}"}.}

\item{auxiliaryWeights}{See \code{"\linkS4class{saeObj}"}.}
}
\value{
An object of class \code{sadObj} if \code{f} is of structure `x ~ NULL | g',
an object of class \code{saeObj} otherwise.
}
\description{
Simple wrapper to \code{new("sa[de]Obj")}.
If missing, it adds an inclusion variable to \code{data};
it checks for missing in the clustering variable.
Adds comments documenting changes made to the returned object.
}
\examples{

## load data
data("s2", package = "maSAE")
## create sadObj object
sad <- maSAE::saObj(data = s2, f = y ~ NULL | g)
class(sad)
## create saeObj object
s2$s2 <- TRUE
sae <- maSAE::saObj(data = s2, f = y ~ x1 + x2 + x3 | g, s2 = "s2")
class(sae)
}
\seealso{
\code{"\linkS4class{saeObj}"}, \code{"\linkS4class{sadObj}"}.
}
