\name{predict.maboost}
\alias{predict.maboost}

\title{
Predict a data set using maboost
}

\description{
\code{predict} classifies a new set of observations from a 
previously built classifier.  This function will provide either 
a vector of new classes, class probability estimates, or both.
}

\usage{
\method{predict}{maboost}(object, newdata = NULL, type = c("class", "prob", "both","F"),n.iter=NULL,\dots)
}

\arguments{
  \item{object}{object generated by \code{maboost}.}
  \item{newdata}{new data set to predict.  This data set must be
    of type \sQuote{data.frame}.  Default = NULL.  When default = NULL, predict
    produces predictions for the original training set.}
  \item{type}{choice for preditions.  
    type=\dQuote{class} returns the default class labels.
    type=\dQuote{prob} returns the probability class estimates.
    type=\dQuote{both} returns both the default class labels and
    probability class estimates.
    type=\dQuote{F} returns the ensamble average. This is mainly usefull for the multiclass case.
    }
  \item{n.iter}{number of iterations to consider for the prediction.  By default
    this is iter from the \code{maboost} call (n.iter< iter)}
  \item{\dots}{other arguments not used by this function.}
}

\details{
This function was modeled after \code{predict.rpart} and  \code{predict.rpart} and \code{predict.C5.0}.
}

\value{
  \item{fit}{a vector of fitted responses.  Fit will be returned if type=\dQuote{class}.
  }
  \item{prob}{a matrix of class probability estimates. The first column 
    corresponds to the first label in the \sQuote{levels} of the response.  The second 
    column corresponds to the second label in the \sQuote{levels} of the response.  
    Probs are returned whenever type=\dQuote{prob}.
  }
  \item{both}{returns both the vector of fitted responses and class probability
    estimates.  The first element returns the fitted responses and will be labeled
    as \sQuote{class}.  The second element returns the class probability estimates 
    and will be labeled as \sQuote{prob}.
  }
  \item{F}{this can be used in the multiclass case.}
}

\note{
This function is invoked by the \code{summary} S3 generics invoked with an \code{maboost} object.  If an error occurs in one of the above
commands then try using this command directly to track possible errors.
Also, the newdata data set must be of type \sQuote{data.frame} when invoking
\code{summary}.
}
\seealso{
  \code{\link{summary.maboost}},\code{\link{print.maboost}},
  \code{\link{update.maboost}}
}
\keyword{methods}