% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_macrosynteny.R
\name{compute_macrosynteny}
\alias{compute_macrosynteny}
\title{Compute significant macrosynteny blocks}
\usage{
compute_macrosynteny(orthologs_df, pvalue_threshold = 0.001)
}
\arguments{
\item{orthologs_df}{dataframe. orthologs with genomic coordinates loaded with load_orthologs()}

\item{pvalue_threshold}{numeric. threshold for significancy. (default equals 0.001)}
}
\value{
A dataframe object
}
\description{
This is a function to generate the contingency table of an orthologs dataframe and
apply fischer test to calculate the significant associations. It outputs a dataframe shaped as following :
sp1.Chr,sp2.Chr,a,pval,significant,pval_adj
}
\examples{
# basic usage of compute_macrosynteny : 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)
                               
my_macrosynteny <- compute_macrosynteny(my_orthologs)

}
