% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numderiv.r
\docType{methods}
\name{numderiv}
\alias{ANY,array-method}
\alias{ANY,madness-method}
\alias{numderiv}
\alias{numderiv,ANY,array-method}
\alias{numderiv,ANY,madness-method}
\title{Numerical (approximate) Differentiation.}
\usage{
numderiv(f, x, eps=1e-8, type=c('forward','central','backward'),...)

\S4method{numderiv}{ANY,array}(f, x, eps = 1e-08, type = c("forward",
  "central", "backward"), ...)

\S4method{numderiv}{ANY,madness}(f, x, eps = 1e-08, type = c("forward",
  "central", "backward"), ...)
}
\arguments{
\item{f}{a function, to be evaluated at and near \code{x}.}

\item{x}{array, matrix, or \code{madness} object.}

\item{eps}{the 'epsilon', a small value added or subtracted from \code{x} to
compute the first differences.}

\item{type}{the type of first difference, case-insensitive, substrings ok.}

\item{...}{arguments passed on to \code{f}.}
}
\value{
A matrix if \code{x} is numeric; a \code{madness} object if
\code{x} is a \code{madness} object.
}
\description{
Approximates the derivative of a function at the input
by numerical methods.
}
\details{
For a multivariate-valued function of multivariate
data, approximates the derivative at a point via the
forward, central, or backward first differences, 
returning a \code{madness} object.
}
\examples{
f <- function(x,h) {
  cos(x + h)
}
x <- array(rnorm(100),dim=c(10,10))
madx <- numderiv(f,x,1e-8,h=pi)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}

