% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolSplitSubtype.R
\name{toolSplitSubtype}
\alias{toolSplitSubtype}
\title{Tool: SplitSubtype}
\usage{
toolSplitSubtype(subtype, components, sep = ":")
}
\arguments{
\item{subtype}{A character string which can be split with the given separator into smaller entities}

\item{components}{A named list with the same length as the subtype has entities. Names of the list
are used as names of the entities while the content of each list element represents the allowed values
of that given entity. If all values are allowed use NULL as entry.}

\item{sep}{separator to be used for splitting}
}
\value{
A named list with the different entities of the given subtype
}
\description{
This function can split a subtype string into smaller entities based on 
a given separator and check whether these entities exist in a reference list
}
\examples{
toolSplitSubtype("mymodel:myversion:myworld", list(model=c("mymodel","notmymodel"), 
                                                   version=c("myversion","42"), 
                                                   world="myworld"))

}
\author{
Jan Philipp Dietrich
}
