% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-catalogue_functions.R
\name{as_valueType}
\alias{as_valueType}
\title{Validate and coerce an object according to a given valueType}
\usage{
as_valueType(x, valueType = "text")
}
\arguments{
\item{x}{Object to be coerced. Can be a vector.}

\item{valueType}{A character string of the valueType used to coerce x.}
}
\value{
The object coerced accordingly to the input valueType.
}
\description{
Attributes a valueType to an object, that can be a vector, or in a tibble
using \link[dplyr:mutate]{dplyr::mutate}.
}
\details{
The valueType is a property of a variable and is required in certain
functions to determine the handling of the variables. The valueType refers
to the OBiBa-internal type of a variable. It is specified in a data
dictionary in a column \code{valueType} and can be associated with variables as
attributes. Acceptable valueTypes include 'text', 'integer', 'decimal',
'boolean', datetime', 'date'). The full list of OBiBa valueType
possibilities and their correspondence with R data types are available using
\link{valueType_list}.
}
\examples{
{

# use DEMO_files provided by the package

dataset <- DEMO_files$dataset_TOKYO
valueType_of(dataset$dob)
valueType_guess(dataset$dob)
as_valueType(dataset$dob,'date') 

# as_valueType is compatible with tidyverse philosophy
library(dplyr)
mtcars \%>\% mutate(cyl = as_valueType(cyl,'integer'))

}

}
\seealso{
\href{https://opaldoc.obiba.org/en/dev/magma-user-guide/value/type.html}{Opal documentation}
}
